/****
 * vB Post Templates
 * Copyright 2008; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

function build_posttemplates_popup(menu, obj)
{
	for (var cat in posttemplates)
	{
		if (!YAHOO.lang.hasOwnProperty(posttemplates, cat))
		{
			continue;
		}

		var category = document.createElement('div');
		category.className = 'thead';
		category.innerHTML = cat;
		menu.appendChild(category);

		for (ptid in posttemplates[cat])
		{
			if (!YAHOO.lang.hasOwnProperty(posttemplates[cat], ptid))
			{
				continue;
			}

			option = document.createElement('div');
			option.editorid = EDITOR_ID;
			option.controlkey = obj.id;
			option.ptid = ptid;

			option.className = 'osmilie';
			option.style.padding = '4px';
			option.innerHTML = posttemplates[cat][ptid];

			option.onmouseover = option.onmouseout = option.onmousedown = option.onmouseup = vB_Text_Editor_Events.prototype.menuoption_onmouseevent;

			option.onclick = posttemplates_onclick;

			menu.appendChild(option);
		}
	}
}

function posttemplates_onclick(e)
{
	PostTemplate = new vB_AJAX_PostTemplate(this.ptid, vB_Editor[this.editorid].wysiwyg_mode, vB_Editor[this.editorid].parsesmilies, this.editorid);
	PostTemplate.fetch();
	vBmenu.hide();
}

function vB_AJAX_PostTemplate(template, wysiwyg, allowsmilie, editorid)
{
	this.template = template;
	this.wysiwyg = wysiwyg;
	this.allowsmilie = allowsmilie;
	this.editorid = editorid;

	this.fetch = function()
	{
		YAHOO.util.Connect.asyncRequest("POST", "ajax.php?do=posttemplate&template=" + this.template + "&wysiwyg=" + this.wysiwyg + "&allowsmilie=" + this.allowsmilie, {
			success: this.fetched,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=posttemplate&template=" + this.template + "&wysiwyg=" + this.wysiwyg + "&allowsmilie=" + this.allowsmilie);
	}

	this.fetched = function(ajax)
	{
		if (ajax.responseXML)
		{
			if (ajax.responseXML.getElementsByTagName('message') && ajax.responseXML.getElementsByTagName('message')[0])
			{
				vB_Editor[this.editorid].insert_text(ajax.responseXML.getElementsByTagName('message')[0].firstChild.nodeValue);
			}
		}
	}
}

/**
* We'll overwrite the JS functions here since we can't hook into 'em
* It's not pretty, but what the hell =)
*/
function overload_vB_Editor()
{
	vB_Editor[EDITOR_ID].init_popup_menu = function(obj)
	{
		if (this.disabled)
		{
			return false;
		}
		var menu;

		switch (obj.cmd)
		{
			case 'fontname':
			{
				menu = this.init_menu_container('fontname', '200px', '250px', 'auto');
				this.build_fontname_popup(obj, menu);
				break;
			}
			case 'fontsize':
			{
				menu = this.init_menu_container('fontsize', 'auto', 'auto', 'visible');
				this.build_fontsize_popup(obj, menu);
				break;
			}
			case 'forecolor':
			{
				menu = this.init_menu_container('forecolor', 'auto', 'auto', 'visible');
				this.build_forecolor_popup(obj, menu);
				break;
			}
			case 'smilie':
			{
				menu = this.init_menu_container('smilie', '175px', '250px', 'auto');
				this.build_smilie_popup(obj, menu);
				break;
			}
			case 'attach':
			{
				if (typeof vB_Attachments != 'undefined' && vB_Attachments.has_attachments())
				{
					menu = this.init_menu_container('attach', 'auto', 'auto', 'visible');
					this.build_attachments_popup(menu, obj);
				}
				else
				{
					// no popup to display
					fetch_object('manage_attachments_button').onclick();
					return false;
				}
			}
			case 'posttemplate':
			{
				menu = this.init_menu_container('posttemplate', '200px', '250px', 'auto');
				build_posttemplates_popup(menu, obj);
			}
		}

		this.popups[obj.cmd] = this.controlbar.appendChild(menu);

		set_unselectable(menu);

		return true;
	}
}

function do_switch_editor_mode(ajax)
{
	if (ajax.responseXML)
	{
		// destroyer
		var parsetype = vB_Editor[ajax.argument[0]].parsetype;
		var parsesmilies = vB_Editor[ajax.argument[0]].parsesmilies;
		var ajax_extra = vB_Editor[ajax.argument[0]].ajax_extra;

		vB_Editor[ajax.argument[0]].destroy();

		var message_node = ajax.responseXML.getElementsByTagName('message')[0];
		if (typeof message_node != 'undefined')
		{
			message_node = message_node.firstChild;
		}
		var parsed_text = (message_node ? message_node.nodeValue : '');

		var matches = parsed_text.match(/&#([0-9]+);/g);
		if (matches)
		{
			for (var i = 0; typeof matches[i] != 'undefined'; i++)
			{
				if (submatch = matches[i].match(/^&#([0-9]+);$/))
				{
					parsed_text = parsed_text.replace(submatch[0], String.fromCharCode(submatch[1]));
				}
			}
		}

		vB_Editor[ajax.argument[0]] = new vB_Text_Editor(ajax.argument[0], ajax.argument[1], parsetype, parsesmilies, parsed_text, ajax_extra);
		vB_Editor[ajax.argument[0]].check_focus();
		fetch_object(ajax.argument[0] + '_mode').value = ajax.argument[1];

		overload_vB_Editor();
	}
}

overload_vB_Editor();